﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Xsl;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        internal class MethodCompetencesNext : BaseAPIMethod
        {
            private PI.GM.N610.ELearning.BL.BO.Exercise _exercise = null;
            private long _context_id = -1;
            private long _course_id = -1;
            private long _unit_id = -1;
            private long _exercise_id = -1;
            private int _mode_id = 0;

            public MethodCompetencesNext(ELearning Component)
                : base(Component)
            {
            }

            public override string Name
            {
                get { return "competencesnext"; }
            }

            protected override bool DoValidate()
            {
                return (_context_id > 0) && (_course_id > 0) && (_unit_id > 0);
            }

            protected override void DoReadRequestParams()
            {
                long.TryParse(Component.APIRequestParams["context_id"], out _context_id);
                long.TryParse(Component.APIRequestParams["course_id"], out _course_id);
                long.TryParse(Component.APIRequestParams["unit_id"], out _unit_id);
                long.TryParse(Component.APIRequestParams["exercise_id"], out _exercise_id);

                int.TryParse(Component.APIRequestParams["mode_id"], out _mode_id);
            }

            protected override GResponseData DoGetGResponseData()
            {
                if (User != null)
                {
                    XslCompiledTransform _apiXSLTransform = Component.WebPageEngine.ComponentXSL("c_apimobile");
                    BL.ZSBELearning.ContextParam _contextParam = new BL.ZSBELearning.ContextParam(Component.BLELearning, _context_id, _course_id, _unit_id, _exercise_id, null, _mode_id);                                    
                    
                    _contextParam.ExerciseState = GM.N610.ELearning.BL.ELearning.ExerciseState.Load;
                    _contextParam = Component.BLELearning.Exercise.Navigation.RestoreNext(_contextParam);

                    if (_contextParam.AuxyliaryPages == BL.Dictionary.AuxyliaryPagesType.None)
                    {
                        Component.BLELearning.BLELearning.Statistic.SaveEventLoad(_contextParam.ContextObjectID, _contextParam.Course, _contextParam.UnitOut, _contextParam.ExerciseOut, null);
                    }

                    GResponseData _GResponseData = Component.BLELearning.APIMobile.LoadExercise(_contextParam, _apiXSLTransform);
                    if (_GResponseData != null)
                    {
                        StatusCode = StatusCodeType.OK;
                        return _GResponseData;
                    }
                    else
                    {
                        AddErrorMessage("Nie znaleziono ćwiczenia dla zadanych parametrów.");
                        StatusCode = StatusCodeType.NotFound;
                    }
                }
                return null;
            }
        }
    }
}